<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<title>Davids und Alexs LSF Notenprüfer!</title>
	<style type="text/css">
		body {
			font: 13px/1.5 'Helvetica Neue', Arial, 'Liberation Sans', FreeSans, sans-serif;
		}
		table{
			border: 1px solid black;
			box-shadow: 5px 5px 5px #888;
		}
		tr {
			text-align: left;
		}
		
		tr:hover {
			background: rgba(255,255,255,0.05);
		}
		
		th,td {
			text-align: center; padding: 5px;
		}
		
		tr:hover {
			background: rgba(255,255,255,0.05);
		}

		.gray {
			background: #eeeeee;
		}
		
	</style>
</head>
<body>
<?php

include('config.php');
include('lsf_connect.php');
$content->execute('https://lsf.htw-berlin.de/qisserver/rds?state=hisreports&status=transform&publishid=0&vmfile=no&moduleCall=Pruefungsleistungen&asi='.$matches[0][1]);
$content->close();

$file = fopen('check.pdf', 'w');
fwrite($file, $content);
fclose($file);

include('class.pdf2text.php');
$a = new PDF2Text();
$a->setFilename('check.pdf');
$a->decodePDF();
$search = '
 *';
$checkText = str_replace($search, '', $a->output());
$search = ' 
Studien- und Pr';
$checkText = str_replace($search, '', $checkText);
$search = 'P/W
 ';
$checkText = str_replace($search, '', $checkText);
$countMatches = preg_match_all('%\n \n([A-Za-z0-9 -/]*?)\n([A-Z0-9 -/]*?)\n([0-9],[0-9])\n([A-Z]* / [0-9])\n([0-9])\n([A-Z]*)%s', $checkText, $matches, PREG_SET_ORDER);

	$countScores = 0;
	$countLPs = 0;
	$rowbreak = 1;
	echo '<table><tr><th>Fach</th><th>Semester / Termin</th><th>Note</th><th>Status / Versuch</th><th>LP</th><th>P/W</th></tr>';
	for($i=0; $i < $countMatches; $i++){
		if(($i+1)%2 == 0) {
			echo '<tr class="gray">';
		}
		else {
			echo '<tr>';
		}
		for ($k = 1; $k <= 6; $k++) {
			echo '<td>'.$matches[$i][$k].'</td>';
		}
		echo '</tr>';
		$countScores += str_replace(',', '.', $matches[$i][3]) * $matches[$i][5];
		$countLPs += $matches[$i][5];
	}
	echo '</table>';

	echo '<br />Durchschnitt: '.$countScores.' / '.$countLPs.' = '.($countScores / $countLPs);
?>
</body>
</html>